using UnityEngine;
using System.Collections;

// Sets up transformation matrices to scale&scroll water waves
// for the case where graphics card does not support vertex programs.

[ExecuteInEditMode]
public class sa_WaterSimple : MonoBehaviour
{
	public Color mForwardColor;
	public Color mRewindColor;
	public float mTransparentIncrimenter;
	public float mFadeSpeed;
	
	float mNewOpacity;
	float mCurOpacity;
	float mPreOpacity;
	
	void Start()
	{
		s_TimeManager.Get.AddChangeFunction(RewindChange);
		s_TimeManager.Get.AddStartFunction(RewindChange);
		s_TimeManager.Get.AddEndFunction(RewindEnd);
		
		renderer.sharedMaterial.SetVector("_horizonColor", mForwardColor);
	}
	
	void RewindEnd()
	{	
		//Tell fader to go to 0 basically
		mNewOpacity = 0;
		StopCoroutine("Fade");
		StartCoroutine("Fade");
	}
	
	void RewindChange()
	{	
		//Set opacity
		mPreOpacity = mCurOpacity = mNewOpacity;
		
		if (s_TimeManager.sRewindSpeed == 1 || s_TimeManager.sRewindSpeed == -1)
			mNewOpacity = mTransparentIncrimenter;
		else if (s_TimeManager.sRewindSpeed == 2 || s_TimeManager.sRewindSpeed == -2)
			mNewOpacity = mTransparentIncrimenter*2;
		else if (s_TimeManager.sRewindSpeed == 4 || s_TimeManager.sRewindSpeed == -4)
			mNewOpacity = mTransparentIncrimenter*3;
		else if (s_TimeManager.sRewindSpeed == 8 || s_TimeManager.sRewindSpeed == -8)
			mNewOpacity = mTransparentIncrimenter*4;
		else if (s_TimeManager.sRewindSpeed == 0)
			mNewOpacity = 0;
		
		//Start fading in
		StopCoroutine("Fade");
		StartCoroutine("Fade");
	}
	
	IEnumerator Fade()
	{
		while (mPreOpacity < mNewOpacity && mCurOpacity < mNewOpacity //Opacity is going down
			|| mPreOpacity > mNewOpacity && mCurOpacity > mNewOpacity //Opacity is going up
			|| mNewOpacity == 0 && mCurOpacity > 0) //Rewind stopped, opacity going down
		{
			//Incriment opacity
			if (mPreOpacity < mNewOpacity)
				mCurOpacity += 0.033f * mFadeSpeed;
			else
				mCurOpacity -= 0.033f * mFadeSpeed;
			
			//Sets color depening on rewind direction or rewind stopped
			if (mNewOpacity == 0)
			{
				Vector4 col = renderer.sharedMaterial.GetVector("_horizonColor");
				renderer.sharedMaterial.SetVector("_horizonColor", new Vector4(col.x, col.y, col.z, mCurOpacity));
			}
			else if (s_TimeManager.sRewindSpeed <= 0)
				renderer.sharedMaterial.SetVector("_horizonColor", new Vector4(mRewindColor.r, mRewindColor.g, mRewindColor.b, mCurOpacity));
			else
				renderer.sharedMaterial.SetVector("_horizonColor", new Vector4(mForwardColor.r, mForwardColor.g, mForwardColor.b, mCurOpacity));
			
			yield return null;
		}
		
	}
	
	
	
	void Update()
	{
		if( !renderer )
			return;
		Material mat = renderer.sharedMaterial;
		if( !mat )
			return;
		
		Vector4 waveSpeed = mat.GetVector( "WaveSpeed" );
		float waveScale = mat.GetFloat( "_WaveScale" );
		float t = Time.time / 20.0f;
		
		Vector4 offset4 = waveSpeed * (t * waveScale);
		Vector4 offsetClamped = new Vector4(Mathf.Repeat(offset4.x,1.0f), Mathf.Repeat(offset4.y,1.0f), Mathf.Repeat(offset4.z,1.0f), Mathf.Repeat(offset4.w,1.0f));
		mat.SetVector( "_WaveOffset", offsetClamped );
		
		Vector3 scale = new Vector3( 1.0f/waveScale, 1.0f/waveScale, 1 );
		Matrix4x4 scrollMatrix = Matrix4x4.TRS( new Vector3(offsetClamped.x,offsetClamped.y,0), Quaternion.identity, scale );
		mat.SetMatrix( "_WaveMatrix", scrollMatrix );
				
		scrollMatrix = Matrix4x4.TRS( new Vector3(offsetClamped.z,offsetClamped.w,0), Quaternion.identity, scale * 0.45f );
		mat.SetMatrix( "_WaveMatrix2", scrollMatrix );
		
	}
}
